#!/bin/bash

#Path to network configuration
INTERFACES_FILE="/etc/network/interfaces"

# only possible with sudo permission
if [ "$(id -u)" -ne 0 ]; then
    echo "Permission denied, are you root ?"
    exit 1
fi

# Backup of current configuration
cp $INTERFACES_FILE ${INTERFACES_FILE}.bak

# comment out line "auto eth0"
sed -i 's/^auto eth0/#auto eth0/' $INTERFACES_FILE
sed -i 's/^#auto eth0:1/auto eth0:1/' $INTERFACES_FILE

# restart network
echo "changed static ip to dhcp and restart network "
if systemctl is-active --quiet networking; then
    systemctl restart networking
else
    /etc/init.d/networking restart
fi


